local Ingredient = GLOBAL.Ingredient
local RecipeTabs = GLOBAL.RECIPETABS
local Tech = GLOBAL.TECH

--Adds the flags required to read books and use the books tab
local function bookSmart(inst)
	inst:AddTag("bookbuilder") --doesn't allow use of Books Tab for some reason?
	inst:AddComponent("reader") 
end

--Runs bookSmart for every character present in server files
for k,prefabname in ipairs(GLOBAL.DST_CHARACTERLIST) do
	AddPrefabPostInit(prefabname, bookSmart)
end

for k,prefabname in ipairs(GLOBAL.MODCHARACTERLIST) do
	AddPrefabPostInit(prefabname, bookSmart)
end

--Adds all the book recipes to the Magic Tab
AddRecipe("book_birds", {Ingredient("papyrus", 2), Ingredient("bird_egg", 2)}, RecipeTabs.MAGIC, Tech.MAGIC_THREE)
AddRecipe("book_gardening", {Ingredient("papyrus", 2), Ingredient("seeds", 1), Ingredient("poop", 1)}, RecipeTabs.MAGIC, Tech.MAGIC_THREE)
AddRecipe("book_sleep", {Ingredient("papyrus", 2), Ingredient("nightmarefuel", 2)}, RecipeTabs.MAGIC, Tech.MAGIC_THREE)
AddRecipe("book_brimstone", {Ingredient("papyrus", 2), Ingredient("redgem", 1)}, RecipeTabs.MAGIC, Tech.MAGIC_THREE)
AddRecipe("book_tentacles", {Ingredient("papyrus", 2), Ingredient("tentaclespots", 1)}, RecipeTabs.MAGIC, Tech.MAGIC_THREE)
AddRecipe("spear_wathgrithr", {Ingredient("twigs", 2), Ingredient("flint", 2), Ingredient("goldnugget", 2)}, RECIPETABS.WAR, TECH.NONE)
AddRecipe("wathgrithrhat", {Ingredient("goldnugget", 2), Ingredient("rocks", 2)}, RECIPETABS.WAR, TECH.NONE)